/*
 * Decompiled with CFR 0.152.
 */
package com.resource.restaurant;

import com.Application;
import com.android.invoice.domain.ResInvoiceService;
import com.dao.restaurant.ResMapper;
import com.dao.restaurant.ResTableDao;
import com.dto.restaurant.ResInvoiceDto;
import com.utility.ConvertStr;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ResTable {
    private final ResTableDao tableDao;
    private final ResInvoiceService resInvoiceService;
    private final Application application;

    @GetMapping(value={"/ResTable"})
    public ResponseEntity<Map<Object, List<Map<String, Object>>>> getRestaurantTable(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.tableDao.getTableList(request);
    }

    @PostMapping(value={"/ResInvoice"}, consumes={"application/json"})
    public ResponseEntity<Map<String, Object>> postResInvoice(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        List<ResInvoiceDto> dtoList = Arrays.asList(this.tableDao.requireResInvoiceDto(body));
        ResMapper mapper = new ResMapper();
        return this.resInvoiceService.post(mapper.mapFromDtoList(dtoList));
    }

    @GetMapping(value={"/ResInvoice"})
    public ResponseEntity<Map<Object, List<Map<String, Object>>>> getResInvoice(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.tableDao.getResInvoice(request);
    }

    @PostMapping(value={"/callWaiter"}, consumes={"application/json"})
    public ResponseEntity<Map<String, Object>> postCallWaiter(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            this.tableDao.callWaiter(body);
            model.put("success", "Waiter Successfully has been called");
            success.add(model);
        }
        catch (Exception e) {
            failure.add(new TncException(TncExceptionMessages.WRONG_JSON_STRUCT).getErrorMap());
        }
        return ConvertStr.getMapResponseEntity((String)"callWaiter", failure, success);
    }

    @PutMapping(value={"/ResInvoice"}, consumes={"application/json"})
    public ResponseEntity<Map<String, Object>> postRInvoiceEdit(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.tableDao.postEditInvoice(body);
    }

    @PutMapping(value={"/ResInvoice/request"}, consumes={"application/json"})
    public ResponseEntity<Map<String, Object>> postRInvoiceWaiter(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.tableDao.sendRequests(body);
    }

    public ResTable(ResTableDao tableDao, ResInvoiceService resInvoiceService, Application application) {
        this.tableDao = tableDao;
        this.resInvoiceService = resInvoiceService;
        this.application = application;
    }
}

